package fr.asip.cps3.exemple.vues.menus;

import java.awt.Color;
import javax.swing.JMenu;

/**
 * Classe modlisant un menu
 *
 */
public class Menu extends JMenu {
	
	private static final long serialVersionUID = -8167177353251703396L;

	/**
	 * Identifiant du menu parent
	 */	
	private String idParent;
	
	/**
	 * Identifiant du menu
	 */
	private String id;
	
	/**
	 * Dtermine si le menu doit tre affich ou non (dans le cas du verrouillage des menus)
	 */
	private boolean actif;
	
	/**
	 * Constructeur  5 arguments
	 * @param id Identifiant du menu
	 * @param idParent Identifiant du menu parent
	 * @param label Libell du menu
	 * @param enable Boolen attestant du caractre actionnable du menu
	 * @param visible Boolen attestant du caractre visible du menu
	 */
	public Menu(String id, String idParent, String label, boolean enable, boolean visible) {
		super(label);
		this.idParent=idParent;
		this.id=id;
		setVisible(visible);
		setEnabled(enable);
		actif=enable;
		setBackground(Color.WHITE);
	}

	/**
	 * Accesseur
	 * @return L'identifiant du menu parent
	 */
	public String getIdParent() {
		return idParent;
	}

	/**
	 * Accesseur
	 * @return L'identifiant du menu
	 */
	public String getId() {
		return id;
	}

	/**
	 * Mutateur de l'identifiant du menu
	 * @param id Identifiant du menu
	 */
	public void setId(String id) {
		this.id = id;
	}

	/**
	 * Acceseur
	 * Dtermine si le menu doit tre affich ou non (dans le cas du verrouillage des menus)
	 * @return true ou false
	 */
	public boolean isActif() {
		return actif;
	}

	/**
	 * Mutateur
	 * Affecte le boolan permettant de dterminer si le menu doit tre affich ou non (dans le cas du verrouillage des menus)
	 * @param true ou false
	 */
	public void setActif(boolean actif) {
		this.actif = actif;
	}
	
}
